////////////////////////////////////////////////////////////////////
//
//    DESCRIPTION:
//
//    AUTHOR:
//
//    HISTORY:
//
////////////////////////////////////////////////////////////////////

#ifndef ISLAND_EVENTS_HEADER
#define ISLAND_EVENTS_HEADER

#include "ldwTypes.h"
#include "../Game/theGameState.h"
enum IslandEventId
{
	eNoEvent = 0,

	eTsunamiEvent,
	ePlagueOfAntsEvent,
	eScienceFairEvent,
	eAllergySeasonEvent,
	eIsolaDayEvent,
	eDayOfHonorEvent,
	eCanoeFromOtherSideEvent,
	eMysteriousFogFoodBonusEvent,
	eMysteriousFogFoodPenaltyEvent,
	eMysteriousFogTechBonusEvent,
	eMysteriousFogTechPenaltyEvent,
	//eDayOfHonorEvent,
	eBlessingsDayEvent,
	eMiraculousBloomEvent,
	eTheReflectionInTheWaterEvent,

	eDaredevilEvent,
	eGhostlyNatureDreamEvent,
	eGhostlyMagicDreamEvent,
	eXtalOfReflectionsEvent,
	eBitterBrownBeansScience1Event,
	eBitterBrownBeansScience2Event,
	eAncientTabletScience1Event,
	eAncientTabletScience2Event,
	eTheLowTideEvent,
	eAntsAndGranaryEvent,
	eTheGreenPearlEvent,
	eTheBluePearlEvent,
	eTheLazyApprenticeEvent,
	eTheOmenInTheCloudsEvent,
	eThePlayfulOttersEvent,
	//eTheSirenSongEvent,
	eTheAntHillEvent,
	eTheRedStarfishEvent,
	eTheBlueStarfishEvent,
	//eTheEternalTorchEvent,
	eTheAntInTheBedEvent,
	eTheLoversFemaleEvent,
	eTheLoversMaleEvent,
	eTheMedicalEmergencyEvent,
	//eTheMonsterButterflyEvent,

	eTheQuartzPhialEvent,
	eTheObsidianPhialEvent,
	eTheAmberPhialEvent,

	eTheMangoAndThePapayaEvent,
	eTheCrateOfMangosPapayasAndBananasEvent,
	eTheBeeEvent,
	eTheNoisyBirdEvent,
	eTheHoleInTheHutEvent,
	eTheRoyalJellyEvent,
	eTheShootingStarEvent,
	eTheChiefsAddressEvent,
	eTheRainySeasonEvent,
	eTheColdSnapEvent,
	//eTheSwarmOfBeesEvent,
	eTheSaltyAirEvent,
	eTheOppressiveHumidityEvent,
//	ePelicanGriefEvent,
//	eTheHungrySharkEvent,
	eFoggyHeadedEvent,
	eTheStingingJellyfishEvent,
	eTheMushroomCelebrationEvent,
	eTheYellowGeckosEvent,
	eTheReturnOfBigglesEvent,
	eAnotherBarrelOBabiesEvent,
	
	eIslandEventCount
};

enum EventResourceId
{
	eResourceFood = 0,
	eResourceTech,
	eResourcePopulation,
	eResourceChildren,
	eResourceAdults,
	eResourceHoney,
	eResourceFruit,

	eNumResources
};
class CIslandEvent;
class ldwScene;

class CIslandEvents
{
public:

	static CIslandEvents *Get();
	static CIslandEvents &Ref();

	static void           Destroy();

	~CIslandEvents (); // class destructor

	bool IsTimeForAnEvent();

	bool FireEvent(ldwScene *parentScene);

	void ShowAll(ldwScene *parentScene);

	bool ForceEvent(ldwScene *parentScene,IslandEventId eventId);

	int PercentOfResource(int percent ,EventResourceId whichResource);

	int EventScalor(int prizeBaseAmount);

private:
	theGameState  *gs;
	CIslandEvents ();  // class constructor

	static CIslandEvents *mInstance;

	ldwUINT32 mLastEventTime;

 	static CIslandEvent *mEventList[eIslandEventCount];
	static bool			 mEventHasFired[eIslandEventCount];
};

#endif